﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/

#include "gameFunctions/nestedEval.as"
define_fadeScreen = function(command_obj)
{
	command_obj.run = function( thisCommand_obj )
	{
		if(TRACE_SCRIPT)
			trace("\nFade:  "+thisCommand_obj.data.fadeDir);
		
		var afterFade = function(){
			if(thisCommand_obj.data.waitForEnd)	// if:  wait for fade
				thisCommand_obj.nextEvent();
		}// afterFade()
		
		// start the transition
		var command = (thisCommand_obj.data.fadeDir=="out") ? "doFadeOut" : "doFadeIn";
		TRANSITION[command]()
			.then(afterFade);
		
		// run next command
		if(!thisCommand_obj.data.waitForEnd)	// if:  don't wait
			thisCommand_obj.nextEvent();
	}// run()
}// define_fadeScreen()